#ifndef CE2_TST_DES_H
#define CE2_TST_DES_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/
#include "CryptoEngine2.h"
#include "CE2_TST_Config.h"
#include "CE2_TST_Common.h"
#include "stdio.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tew Mar 06 13:32:57 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains test functions for DES cryptography
* which worked with LibTomCrypt.
* 
* \version CE2_TST_DES.h#1:csrc:1
* \author Masiuk Aliaksandr
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/

#define TST_NAME_STRING_LEN 150
#define TST_FUNC_STRING_LEN 100
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536

#define TST_MAX_SINGLE_DES_BLOCK_SIZE_IN_BYTS 8
#define TST_DES_CONTEXT_SWITCH_DATA_SIZE  2048
#define	TST_ERROR_DES_4_KEYSINUSE 	  4
#define	TST_ERROR_DES_0_KEYSINUSE 	  0
#define	TST_ERROR_ENCRYPTDECRYPTFLAG  8
#define	TST_ERROR_OPERATIONMODE       8

#define TST_ENCRYPT  0 
#define TST_DECRYPT  1

/* Default log file name */
#define TST_DES_STD_LOG_FILE_NAME "DES_TEST_LOG.TXT"

/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/

/* test data structure */
typedef struct TST_DES_TestDataStruct
{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CE2_DES_Key_t 				TST_Key;
	CE2_DES_NumOfKeys_t		TST_NumOfKeys;
	CE2_DES_Iv_t				TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CE2_DES_OperationMode_t	TST_OperationMode;
} TST_DES_TestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/

/***************************************************************
* Function Name: 
*  CE2_TST_DES
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for DES integrated API
*  This function Encryprts and Decrypts known vectors using DES
*  DES modes                   - CBC/ECB
*  Vector sizes used (in bytes) - 16/32/512/1536
*  Key Size used (in bits)	    - 128/192/256
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Call the CE2_DES function to use the DES encryprion/decryption process;
*  -# Compare the outputted result to the expected one.
***************************************************************/
CE2Error_t CE2_TST_DES(FILE *out);

#ifdef __cplusplus
}
#endif

#endif /* End of CE2_TST_DES_H */
